"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns an array of JobListEntry objects of the specified length. Each JobListEntry object contains a job's state, a job's ID, and a value that indicates whether the job is a job part, in the case of export jobs. Calling this API action in one of the US regions will return jobs from the list of all jobs associated with this account in all US regions.

    Args:
        max_results(int, optional): The number of JobListEntry objects to return. Defaults to None.
        next_token(str, optional): HTTP requests are stateless. To identify what object comes "next" in the list of JobListEntry objects, you have the option of specifying NextToken as the starting point for your returned list. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.snowball.jobs.list(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.snowball.jobs.list
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="snowball",
        operation="list_jobs",
        op_kwargs={"MaxResults": max_results, "NextToken": next_token},
    )
