"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def update(hub, ctx, job_id: str, shipment_state: str) -> Dict:
    r"""
    **Autogenerated function**

    Updates the state when a shipment state changes to a different state.

    Args:
        job_id(str): The job ID of the job whose shipment date you want to update, for example JID123e4567-e89b-12d3-a456-426655440000.
        shipment_state(str): The state of a device when it is being shipped.  Set to RECEIVED when the device arrives at your location. Set to RETURNED when you have returned the device to AWS.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.snowball.job.shipment_state.update(
                ctx, job_id=value, shipment_state=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.snowball.job.shipment_state.update job_id=value, shipment_state=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="snowball",
        operation="update_job_shipment_state",
        op_kwargs={"JobId": job_id, "ShipmentState": shipment_state},
    )
