"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def cancel(hub, ctx, job_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Cancels the specified job. You can only cancel a job before its JobState value changes to PreparingAppliance. Requesting the ListJobs or DescribeJob action returns a job's JobState as part of the response element data returned.

    Args:
        job_id(str): The 39-character job ID for the job that you want to cancel, for example JID123e4567-e89b-12d3-a456-426655440000.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.snowball.job.init.cancel(ctx, job_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.snowball.job.init.cancel job_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="snowball",
        operation="cancel_job",
        op_kwargs={"JobId": job_id},
    )


async def create(
    hub,
    ctx,
    job_type: str = None,
    resources: Dict = None,
    on_device_service_configuration: Dict = None,
    description: str = None,
    address_id: str = None,
    kms_key_arn: str = None,
    role_arn: str = None,
    snowball_capacity_preference: str = None,
    shipping_option: str = None,
    notification: Dict = None,
    cluster_id: str = None,
    snowball_type: str = None,
    forwarding_address_id: str = None,
    tax_documents: Dict = None,
    device_configuration: Dict = None,
    remote_management: str = None,
    long_term_pricing_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a job to import or export data between Amazon S3 and your on-premises data center. Your AWS account must have the right trust policies and permissions in place to create a job for a Snow device. If you're creating a job for a node in a cluster, you only need to provide the clusterId value; the other job attributes are inherited from the cluster.   Only the Snowball; Edge device type is supported when ordering clustered jobs. The device capacity is optional. Availability of device types differ by AWS Region. For more information about Region availability, see AWS Regional Services.    AWS Snow Family device types and their capacities.    Snow Family device type: SNC1_SSD    Capacity: T14   Description: Snowcone       Snow Family device type: SNC1_HDD    Capacity: T8   Description: Snowcone       Device type: EDGE_S    Capacity: T98   Description: Snowball Edge Storage Optimized for data transfer only       Device type: EDGE_CG    Capacity: T42   Description: Snowball Edge Compute Optimized with GPU      Device type: EDGE_C    Capacity: T42   Description: Snowball Edge Compute Optimized without GPU      Device type: EDGE    Capacity: T100   Description: Snowball Edge Storage Optimized with EC2 Compute      Device type: STANDARD    Capacity: T50   Description: Original Snowball device  This device is only available in the Ningxia, Beijing, and Singapore AWS Regions.        Device type: STANDARD    Capacity: T80   Description: Original Snowball device  This device is only available in the Ningxia, Beijing, and Singapore AWS Regions.

    Args:
        job_type(str, optional): Defines the type of job that you're creating. . Defaults to None.
        resources(Dict, optional): Defines the Amazon S3 buckets associated with this job. With IMPORT jobs, you specify the bucket or buckets that your transferred data will be imported into. With EXPORT jobs, you specify the bucket or buckets that your transferred data will be exported from. Optionally, you can also specify a KeyRange value. If you choose to export a range, you define the length of the range by providing either an inclusive BeginMarker value, an inclusive EndMarker value, or both. Ranges are UTF-8 binary sorted. Defaults to None.
        on_device_service_configuration(Dict, optional): Specifies the service or services on the Snow Family device that your transferred data will be exported from or imported into. AWS Snow Family supports Amazon S3 and NFS (Network File System). Defaults to None.
        description(str, optional): Defines an optional description of this specific job, for example Important Photos 2016-08-11. Defaults to None.
        address_id(str, optional): The ID for the address that you want the Snow device shipped to. Defaults to None.
        kms_key_arn(str, optional): The KmsKeyARN that you want to associate with this job. KmsKeyARNs are created using the CreateKey AWS Key Management Service (KMS) API action. Defaults to None.
        role_arn(str, optional): The RoleARN that you want to associate with this job. RoleArns are created using the CreateRole AWS Identity and Access Management (IAM) API action. Defaults to None.
        snowball_capacity_preference(str, optional): If your job is being created in one of the US regions, you have the option of specifying what size Snow device you'd like for this job. In all other regions, Snowballs come with 80 TB in storage capacity. For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the Snowcone User Guide or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the Snowcone User Guide. Defaults to None.
        shipping_option(str, optional): The shipping speed for this job. This speed doesn't dictate how soon you'll get the Snow device, rather it represents how quickly the Snow device moves to its destination while in transit. Regional shipping speeds are as follows:   In Australia, you have access to express shipping. Typically, Snow devices shipped express are delivered in about a day.   In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express are delivered in about a day. In addition, most countries in the EU have access to standard shipping, which typically takes less than a week, one way.   In India, Snow devices are delivered in one to seven days.   In the US, you have access to one-day shipping and two-day shipping.  . Defaults to None.
        notification(Dict, optional): Defines the Amazon Simple Notification Service (Amazon SNS) notification settings for this job. Defaults to None.
        cluster_id(str, optional): The ID of a cluster. If you're creating a job for a node in a cluster, you need to provide only this clusterId value. The other job attributes are inherited from the cluster. Defaults to None.
        snowball_type(str, optional): The type of AWS Snow Family device to use for this job.   For cluster jobs, AWS Snow Family currently supports only the EDGE device type.  The type of AWS Snow device to use for this job. Currently, the only supported device type for cluster jobs is EDGE. For more information, see Snowball Edge Device Options in the Snowball Edge Developer Guide. For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the Snowcone User Guide or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the Snowcone User Guide. Defaults to None.
        forwarding_address_id(str, optional): The forwarding address ID for a job. This field is not supported in most Regions. Defaults to None.
        tax_documents(Dict, optional): The tax documents required in your AWS Region. Defaults to None.
        device_configuration(Dict, optional): Defines the device configuration for an AWS Snowcone job. For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the Snowcone User Guide or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the Snowcone User Guide. Defaults to None.
        remote_management(str, optional): Allows you to securely operate and manage Snowcone devices remotely from outside of your internal network. When set to INSTALLED_AUTOSTART, remote management will automatically be available when the device arrives at your location. Otherwise, you need to use the Snowball Client to manage the device. Defaults to None.
        long_term_pricing_id(str, optional): The ID of the long-term pricing type for the device. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.snowball.job.init.create(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.snowball.job.init.create
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="snowball",
        operation="create_job",
        op_kwargs={
            "JobType": job_type,
            "Resources": resources,
            "OnDeviceServiceConfiguration": on_device_service_configuration,
            "Description": description,
            "AddressId": address_id,
            "KmsKeyARN": kms_key_arn,
            "RoleARN": role_arn,
            "SnowballCapacityPreference": snowball_capacity_preference,
            "ShippingOption": shipping_option,
            "Notification": notification,
            "ClusterId": cluster_id,
            "SnowballType": snowball_type,
            "ForwardingAddressId": forwarding_address_id,
            "TaxDocuments": tax_documents,
            "DeviceConfiguration": device_configuration,
            "RemoteManagement": remote_management,
            "LongTermPricingId": long_term_pricing_id,
        },
    )


async def describe(hub, ctx, job_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about a specific job including shipping information, job status, and other important metadata.

    Args:
        job_id(str): The automatically generated ID for a job, for example JID123e4567-e89b-12d3-a456-426655440000.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.snowball.job.init.describe(ctx, job_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.snowball.job.init.describe job_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="snowball",
        operation="describe_job",
        op_kwargs={"JobId": job_id},
    )


async def update(
    hub,
    ctx,
    job_id: str,
    role_arn: str = None,
    notification: Dict = None,
    resources: Dict = None,
    on_device_service_configuration: Dict = None,
    address_id: str = None,
    shipping_option: str = None,
    description: str = None,
    snowball_capacity_preference: str = None,
    forwarding_address_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    While a job's JobState value is New, you can update some of the information associated with a job. Once the job changes to a different job state, usually within 60 minutes of the job being created, this action is no longer available.

    Args:
        job_id(str): The job ID of the job that you want to update, for example JID123e4567-e89b-12d3-a456-426655440000.
        role_arn(str, optional): The new role Amazon Resource Name (ARN) that you want to associate with this job. To create a role ARN, use the CreateRoleAWS Identity and Access Management (IAM) API action. Defaults to None.
        notification(Dict, optional): The new or updated Notification object. Defaults to None.
        resources(Dict, optional): The updated JobResource object, or the updated JobResource object. . Defaults to None.
        on_device_service_configuration(Dict, optional): Specifies the service or services on the Snow Family device that your transferred data will be exported from or imported into. AWS Snow Family supports Amazon S3 and NFS (Network File System). Defaults to None.
        address_id(str, optional): The ID of the updated Address object. Defaults to None.
        shipping_option(str, optional): The updated shipping option value of this job's ShippingDetails object. Defaults to None.
        description(str, optional): The updated description of this job's JobMetadata object. Defaults to None.
        snowball_capacity_preference(str, optional): The updated SnowballCapacityPreference of this job's JobMetadata object. The 50 TB Snowballs are only available in the US regions. For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the Snowcone User Guide or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the Snowcone User Guide. Defaults to None.
        forwarding_address_id(str, optional): The updated ID for the forwarding address for a job. This field is not supported in most regions. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.snowball.job.init.update(ctx, job_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.snowball.job.init.update job_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="snowball",
        operation="update_job",
        op_kwargs={
            "JobId": job_id,
            "RoleARN": role_arn,
            "Notification": notification,
            "Resources": resources,
            "OnDeviceServiceConfiguration": on_device_service_configuration,
            "AddressId": address_id,
            "ShippingOption": shipping_option,
            "Description": description,
            "SnowballCapacityPreference": snowball_capacity_preference,
            "ForwardingAddressId": forwarding_address_id,
        },
    )
