"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    This action returns a list of the different Amazon EC2 Amazon Machine Images (AMIs) that are owned by your AWS account that would be supported for use on a Snow device. Currently, supported AMIs are based on the CentOS 7 (x86_64) - with Updates HVM, Ubuntu Server 14.04 LTS (HVM), and Ubuntu 16.04 LTS - Xenial (HVM) images, available on the AWS Marketplace.

    Args:
        max_results(int, optional): The maximum number of results for the list of compatible images. Currently, a Snowball Edge device can store 10 AMIs. Defaults to None.
        next_token(str, optional): HTTP requests are stateless. To identify what object comes "next" in the list of compatible images, you can specify a value for NextToken as the starting point for your list of returned images. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.snowball.compatible_image.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.snowball.compatible_image.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="snowball",
        operation="list_compatible_images",
        op_kwargs={"MaxResults": max_results, "NextToken": next_token},
    )
