"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub, ctx, cluster_id: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns an array of JobListEntry objects of the specified length. Each JobListEntry object is for a job in the specified cluster and contains a job's state, a job's ID, and other information.

    Args:
        cluster_id(str): The 39-character ID for the cluster that you want to list, for example CID123e4567-e89b-12d3-a456-426655440000.
        max_results(int, optional): The number of JobListEntry objects to return. Defaults to None.
        next_token(str, optional): HTTP requests are stateless. To identify what object comes "next" in the list of JobListEntry objects, you have the option of specifying NextToken as the starting point for your returned list. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.snowball.cluster.job.list_all(ctx, cluster_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.snowball.cluster.job.list_all cluster_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="snowball",
        operation="list_cluster_jobs",
        op_kwargs={
            "ClusterId": cluster_id,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
