"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def cancel(hub, ctx, cluster_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Cancels a cluster job. You can only cancel a cluster job while it's in the AwaitingQuorum status. You'll have at least an hour after creating a cluster job to cancel it.

    Args:
        cluster_id(str): The 39-character ID for the cluster that you want to cancel, for example CID123e4567-e89b-12d3-a456-426655440000.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.snowball.cluster.init.cancel(ctx, cluster_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.snowball.cluster.init.cancel cluster_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="snowball",
        operation="cancel_cluster",
        op_kwargs={"ClusterId": cluster_id},
    )


async def create(
    hub,
    ctx,
    job_type: str,
    resources: Dict,
    address_id: str,
    role_arn: str,
    snowball_type: str,
    shipping_option: str,
    on_device_service_configuration: Dict = None,
    description: str = None,
    kms_key_arn: str = None,
    notification: Dict = None,
    forwarding_address_id: str = None,
    tax_documents: Dict = None,
    remote_management: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an empty cluster. Each cluster supports five nodes. You use the CreateJob action separately to create the jobs for each of these nodes. The cluster does not ship until these five node jobs have been created.

    Args:
        job_type(str): The type of job for this cluster. Currently, the only job type supported for clusters is LOCAL_USE. For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the Snowcone User Guide or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the Snowcone User Guide.
        resources(Dict): The resources associated with the cluster job. These resources include Amazon S3 buckets and optional AWS Lambda functions written in the Python language. .
        on_device_service_configuration(Dict, optional): Specifies the service or services on the Snow Family device that your transferred data will be exported from or imported into. AWS Snow Family supports Amazon S3 and NFS (Network File System). Defaults to None.
        description(str, optional): An optional description of this specific cluster, for example Environmental Data Cluster-01. Defaults to None.
        address_id(str): The ID for the address that you want the cluster shipped to.
        kms_key_arn(str, optional): The KmsKeyARN value that you want to associate with this cluster. KmsKeyARN values are created by using the CreateKey API action in AWS Key Management Service (AWS KMS). . Defaults to None.
        role_arn(str): The RoleARN that you want to associate with this cluster. RoleArn values are created by using the CreateRole API action in AWS Identity and Access Management (IAM).
        snowball_type(str): The type of AWS Snow Family device to use for this cluster.   For cluster jobs, AWS Snow Family currently supports only the EDGE device type.  For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the Snowcone User Guide or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the Snowcone User Guide.
        shipping_option(str): The shipping speed for each node in this cluster. This speed doesn't dictate how soon you'll get each Snowball Edge device, rather it represents how quickly each device moves to its destination while in transit. Regional shipping speeds are as follows:    In Australia, you have access to express shipping. Typically, Snow devices shipped express are delivered in about a day.   In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express are delivered in about a day. In addition, most countries in the EU have access to standard shipping, which typically takes less than a week, one way.   In India, Snow devices are delivered in one to seven days.   In the United States of America (US), you have access to one-day shipping and two-day shipping.     In Australia, you have access to express shipping. Typically, devices shipped express are delivered in about a day.   In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express are delivered in about a day. In addition, most countries in the EU have access to standard shipping, which typically takes less than a week, one way.   In India, Snow devices are delivered in one to seven days.   In the US, you have access to one-day shipping and two-day shipping.  .
        notification(Dict, optional): The Amazon Simple Notification Service (Amazon SNS) notification settings for this cluster. Defaults to None.
        forwarding_address_id(str, optional): The forwarding address ID for a cluster. This field is not supported in most regions. Defaults to None.
        tax_documents(Dict, optional): The tax documents required in your AWS Region. Defaults to None.
        remote_management(str, optional): Allows you to securely operate and manage Snow devices in a cluster remotely from outside of your internal network. When set to INSTALLED_AUTOSTART, remote management will automatically be available when the device arrives at your location. Otherwise, you need to use the Snowball Client to manage the device. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.snowball.cluster.init.create(
                ctx,
                job_type=value,
                resources=value,
                address_id=value,
                role_arn=value,
                snowball_type=value,
                shipping_option=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.snowball.cluster.init.create job_type=value, resources=value, address_id=value, role_arn=value, snowball_type=value, shipping_option=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="snowball",
        operation="create_cluster",
        op_kwargs={
            "JobType": job_type,
            "Resources": resources,
            "OnDeviceServiceConfiguration": on_device_service_configuration,
            "Description": description,
            "AddressId": address_id,
            "KmsKeyARN": kms_key_arn,
            "RoleARN": role_arn,
            "SnowballType": snowball_type,
            "ShippingOption": shipping_option,
            "Notification": notification,
            "ForwardingAddressId": forwarding_address_id,
            "TaxDocuments": tax_documents,
            "RemoteManagement": remote_management,
        },
    )


async def describe(hub, ctx, cluster_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about a specific cluster including shipping information, cluster status, and other important metadata.

    Args:
        cluster_id(str): The automatically generated ID for a cluster.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.snowball.cluster.init.describe(ctx, cluster_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.snowball.cluster.init.describe cluster_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="snowball",
        operation="describe_cluster",
        op_kwargs={"ClusterId": cluster_id},
    )


async def list_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns an array of ClusterListEntry objects of the specified length. Each ClusterListEntry object contains a cluster's state, a cluster's ID, and other important status information.

    Args:
        max_results(int, optional): The number of ClusterListEntry objects to return. Defaults to None.
        next_token(str, optional): HTTP requests are stateless. To identify what object comes "next" in the list of ClusterListEntry objects, you have the option of specifying NextToken as the starting point for your returned list. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.snowball.cluster.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.snowball.cluster.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="snowball",
        operation="list_clusters",
        op_kwargs={"MaxResults": max_results, "NextToken": next_token},
    )


async def update(
    hub,
    ctx,
    cluster_id: str,
    role_arn: str = None,
    description: str = None,
    resources: Dict = None,
    on_device_service_configuration: Dict = None,
    address_id: str = None,
    shipping_option: str = None,
    notification: Dict = None,
    forwarding_address_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    While a cluster's ClusterState value is in the AwaitingQuorum state, you can update some of the information associated with a cluster. Once the cluster changes to a different job state, usually 60 minutes after the cluster being created, this action is no longer available.

    Args:
        cluster_id(str): The cluster ID of the cluster that you want to update, for example CID123e4567-e89b-12d3-a456-426655440000.
        role_arn(str, optional): The new role Amazon Resource Name (ARN) that you want to associate with this cluster. To create a role ARN, use the CreateRole API action in AWS Identity and Access Management (IAM). Defaults to None.
        description(str, optional): The updated description of this cluster. Defaults to None.
        resources(Dict, optional): The updated arrays of JobResource objects that can include updated S3Resource objects or LambdaResource objects. Defaults to None.
        on_device_service_configuration(Dict, optional): Specifies the service or services on the Snow Family device that your transferred data will be exported from or imported into. AWS Snow Family supports Amazon S3 and NFS (Network File System). Defaults to None.
        address_id(str, optional): The ID of the updated Address object. Defaults to None.
        shipping_option(str, optional): The updated shipping option value of this cluster's ShippingDetails object. Defaults to None.
        notification(Dict, optional): The new or updated Notification object. Defaults to None.
        forwarding_address_id(str, optional): The updated ID for the forwarding address for a cluster. This field is not supported in most regions. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.snowball.cluster.init.update(ctx, cluster_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.snowball.cluster.init.update cluster_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="snowball",
        operation="update_cluster",
        op_kwargs={
            "ClusterId": cluster_id,
            "RoleARN": role_arn,
            "Description": description,
            "Resources": resources,
            "OnDeviceServiceConfiguration": on_device_service_configuration,
            "AddressId": address_id,
            "ShippingOption": shipping_option,
            "Notification": notification,
            "ForwardingAddressId": forwarding_address_id,
        },
    )
