"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, address: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Creates an address for a Snow device to be shipped to. In most regions, addresses are validated at the time of creation. The address you provide must be located within the serviceable area of your region. If the address is invalid or unsupported, then an exception is thrown.

    Args:
        address(Dict): The address that you want the Snow device shipped to.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.snowball.address.create(ctx, address=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.snowball.address.create address=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="snowball",
        operation="create_address",
        op_kwargs={"Address": address},
    )


async def describe(hub, ctx, address_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Takes an AddressId and returns specific details about that address in the form of an Address object.

    Args:
        address_id(str): The automatically generated ID for a specific address.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.snowball.address.describe(ctx, address_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.snowball.address.describe address_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="snowball",
        operation="describe_address",
        op_kwargs={"AddressId": address_id},
    )


async def describe_all(
    hub, ctx, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a specified number of ADDRESS objects. Calling this API in one of the US regions will return addresses from the list of all addresses associated with this account in all US regions.

    Args:
        max_results(int, optional): The number of ADDRESS objects to return. Defaults to None.
        next_token(str, optional): HTTP requests are stateless. To identify what object comes "next" in the list of ADDRESS objects, you have the option of specifying a value for NextToken as the starting point for your list of returned addresses. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.snowball.address.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.snowball.address.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="snowball",
        operation="describe_addresses",
        op_kwargs={"MaxResults": max_results, "NextToken": next_token},
    )
