"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, configuration_set_name: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Create a new configuration set. After you create the configuration set, you can add one or more event destinations to it.

    Args:
        configuration_set_name(str, optional): The name that you want to give the configuration set. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sms_voice.configuration_set_.init.create(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sms_voice.configuration_set_.init.create
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sms-voice",
        operation="create_configuration_set",
        op_kwargs={"ConfigurationSetName": configuration_set_name},
    )


async def delete(hub, ctx, configuration_set_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an existing configuration set.

    Args:
        configuration_set_name(str): ConfigurationSetName.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sms_voice.configuration_set_.init.delete(
                ctx, configuration_set_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sms_voice.configuration_set_.init.delete configuration_set_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sms-voice",
        operation="delete_configuration_set",
        op_kwargs={"ConfigurationSetName": configuration_set_name},
    )


async def list_all(hub, ctx, next_token: str = None, page_size: str = None) -> Dict:
    r"""
    **Autogenerated function**

    List all of the configuration sets associated with your Amazon Pinpoint account in the current region.

    Args:
        next_token(str, optional): A token returned from a previous call to the API that indicates the position in the list of results. Defaults to None.
        page_size(str, optional): Used to specify the number of items that should be returned in the response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sms_voice.configuration_set_.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sms_voice.configuration_set_.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sms-voice",
        operation="list_configuration_sets",
        op_kwargs={"NextToken": next_token, "PageSize": page_size},
    )
