"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def generate(hub, ctx, app_id: str = None, template_format: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Generates an AWS CloudFormation template based on the current launch configuration and writes it to an Amazon S3 object in the customer’s Amazon S3 bucket.

    Args:
        app_id(str, optional): The ID of the application associated with the AWS CloudFormation template. Defaults to None.
        template_format(str, optional): The format for generating the AWS CloudFormation template. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sms.template.generate(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sms.template.generate
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sms",
        operation="generate_template",
        op_kwargs={"appId": app_id, "templateFormat": template_format},
    )
