"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def get_all(
    hub,
    ctx,
    next_token: str = None,
    max_results: int = None,
    vm_server_address_list: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the servers in your server catalog. Before you can describe your servers, you must import them using ImportServerCatalog.

    Args:
        next_token(str, optional): The token for the next set of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return in a single call. The default value is 50. To retrieve the remaining results, make another call with the returned NextToken value. Defaults to None.
        vm_server_address_list(List, optional): The server addresses. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sms.server.init.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sms.server.init.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sms",
        operation="get_servers",
        op_kwargs={
            "nextToken": next_token,
            "maxResults": max_results,
            "vmServerAddressList": vm_server_address_list,
        },
    )
