"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"import_": "import"}


async def delete(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Deletes all servers from your server catalog.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sms.server.catalog.delete(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sms.server.catalog.delete
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="sms", operation="delete_server_catalog", op_kwargs={}
    )


async def import_(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Gathers a complete list of on-premises servers. Connectors must be installed and monitoring all servers to import. This call returns immediately, but might take additional time to retrieve all the servers.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sms.server.catalog.import(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sms.server.catalog.import
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="sms", operation="import_server_catalog", op_kwargs={}
    )
