"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(
    hub, ctx, replication_job_id: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the replication runs for the specified replication job.

    Args:
        replication_job_id(str): The ID of the replication job.
        next_token(str, optional): The token for the next set of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return in a single call. The default value is 50. To retrieve the remaining results, make another call with the returned NextToken value. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sms.replication.run.get_all(ctx, replication_job_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sms.replication.run.get_all replication_job_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sms",
        operation="get_replication_runs",
        op_kwargs={
            "replicationJobId": replication_job_id,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )
