"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def start(hub, ctx, replication_job_id: str, description: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Starts an on-demand replication run for the specified replication job. This replication run starts immediately. This replication run is in addition to the ones already scheduled. There is a limit on the number of on-demand replications runs that you can request in a 24-hour period.

    Args:
        replication_job_id(str): The ID of the replication job.
        description(str, optional): The description of the replication run. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sms.on_demand.replication_run.start(
                ctx, replication_job_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sms.on_demand.replication_run.start replication_job_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sms",
        operation="start_on_demand_replication_run",
        op_kwargs={"replicationJobId": replication_job_id, "description": description},
    )
