"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def start(hub, ctx, app_id: str, description: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Starts an on-demand replication run for the specified application.

    Args:
        app_id(str): The ID of the application.
        description(str, optional): The description of the replication run. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sms.on_demand.app_replication.start(ctx, app_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sms.on_demand.app_replication.start app_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sms",
        operation="start_on_demand_app_replication",
        op_kwargs={"appId": app_id, "description": description},
    )
