"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def disassociate(hub, ctx, connector_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Disassociates the specified connector from AWS SMS. After you disassociate a connector, it is no longer available to support replication jobs.

    Args:
        connector_id(str): The ID of the connector.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sms.connector.disassociate(ctx, connector_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sms.connector.disassociate connector_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sms",
        operation="disassociate_connector",
        op_kwargs={"connectorId": connector_id},
    )


async def get_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Describes the connectors registered with the AWS SMS.

    Args:
        next_token(str, optional): The token for the next set of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return in a single call. The default value is 50. To retrieve the remaining results, make another call with the returned NextToken value. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sms.connector.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sms.connector.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sms",
        operation="get_connectors",
        op_kwargs={"nextToken": next_token, "maxResults": max_results},
    )
