"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__virtualname__ = "change_set"


async def generate(hub, ctx, app_id: str = None, changeset_format: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Generates a target change set for a currently launched stack and writes it to an Amazon S3 object in the customer’s Amazon S3 bucket.

    Args:
        app_id(str, optional): The ID of the application associated with the change set. Defaults to None.
        changeset_format(str, optional): The format for the change set. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sms.change_set_.generate(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sms.change_set.generate
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sms",
        operation="generate_change_set",
        op_kwargs={"appId": app_id, "changesetFormat": changeset_format},
    )
