"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__func_alias__ = {"list_": "list"}


async def list_(
    hub, ctx, app_ids: List = None, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves summaries for all applications.

    Args:
        app_ids(List, optional): The unique application IDs. Defaults to None.
        next_token(str, optional): The token for the next set of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return in a single call. The default value is 100. To retrieve the remaining results, make another call with the returned NextToken value. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sms.apps.list(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sms.apps.list
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sms",
        operation="list_apps",
        op_kwargs={
            "appIds": app_ids,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )
