"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, app_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves output from validating an application.

    Args:
        app_id(str): The ID of the application.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sms.app.validation.output.get(ctx, app_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sms.app.validation.output.get app_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sms",
        operation="get_app_validation_output",
        op_kwargs={"appId": app_id},
    )


async def notify(hub, ctx, app_id: str, notification_context: Dict = None) -> Dict:
    r"""
    **Autogenerated function**

    Provides information to AWS SMS about whether application validation is successful.

    Args:
        app_id(str): The ID of the application.
        notification_context(Dict, optional): The notification information. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sms.app.validation.output.notify(ctx, app_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sms.app.validation.output.notify app_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sms",
        operation="notify_app_validation_output",
        op_kwargs={"appId": app_id, "notificationContext": notification_context},
    )
