"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete(hub, ctx, app_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the validation configuration for the specified application.

    Args:
        app_id(str): The ID of the application.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sms.app.validation.configuration.delete(ctx, app_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sms.app.validation.configuration.delete app_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sms",
        operation="delete_app_validation_configuration",
        op_kwargs={"appId": app_id},
    )


async def get(hub, ctx, app_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about a configuration for validating an application.

    Args:
        app_id(str): The ID of the application.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sms.app.validation.configuration.get(ctx, app_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sms.app.validation.configuration.get app_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sms",
        operation="get_app_validation_configuration",
        op_kwargs={"appId": app_id},
    )


async def put(
    hub,
    ctx,
    app_id: str,
    app_validation_configurations: List = None,
    server_group_validation_configurations: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates or updates a validation configuration for the specified application.

    Args:
        app_id(str): The ID of the application.
        app_validation_configurations(List, optional): The configuration for application validation. Defaults to None.
        server_group_validation_configurations(List, optional): The configuration for instance validation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sms.app.validation.configuration.put(ctx, app_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sms.app.validation.configuration.put app_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sms",
        operation="put_app_validation_configuration",
        op_kwargs={
            "appId": app_id,
            "appValidationConfigurations": app_validation_configurations,
            "serverGroupValidationConfigurations": server_group_validation_configurations,
        },
    )
