"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def start(hub, ctx, app_id: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Starts replicating the specified application by creating replication jobs for each server in the application.

    Args:
        app_id(str, optional): The ID of the application. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sms.app.replication.init.start(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sms.app.replication.init.start
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sms",
        operation="start_app_replication",
        op_kwargs={"appId": app_id},
    )


async def stop(hub, ctx, app_id: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Stops replicating the specified application by deleting the replication job for each server in the application.

    Args:
        app_id(str, optional): The ID of the application. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sms.app.replication.init.stop(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sms.app.replication.init.stop
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sms",
        operation="stop_app_replication",
        op_kwargs={"appId": app_id},
    )
