"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete(hub, ctx, app_id: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the replication configuration for the specified application.

    Args:
        app_id(str, optional): The ID of the application. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sms.app.replication.configuration.delete(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sms.app.replication.configuration.delete
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sms",
        operation="delete_app_replication_configuration",
        op_kwargs={"appId": app_id},
    )


async def get(hub, ctx, app_id: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the application replication configuration associated with the specified application.

    Args:
        app_id(str, optional): The ID of the application. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sms.app.replication.configuration.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sms.app.replication.configuration.get
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sms",
        operation="get_app_replication_configuration",
        op_kwargs={"appId": app_id},
    )


async def put(
    hub, ctx, app_id: str = None, server_group_replication_configurations: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Creates or updates the replication configuration for the specified application.

    Args:
        app_id(str, optional): The ID of the application. Defaults to None.
        server_group_replication_configurations(List, optional): Information about the replication configurations for server groups in the application. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sms.app.replication.configuration.put(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sms.app.replication.configuration.put
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sms",
        operation="put_app_replication_configuration",
        op_kwargs={
            "appId": app_id,
            "serverGroupReplicationConfigurations": server_group_replication_configurations,
        },
    )
