"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete(hub, ctx, app_id: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the launch configuration for the specified application.

    Args:
        app_id(str, optional): The ID of the application. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sms.app.launch_configuration.delete(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sms.app.launch_configuration.delete
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sms",
        operation="delete_app_launch_configuration",
        op_kwargs={"appId": app_id},
    )


async def get(hub, ctx, app_id: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the application launch configuration associated with the specified application.

    Args:
        app_id(str, optional): The ID of the application. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sms.app.launch_configuration.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sms.app.launch_configuration.get
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sms",
        operation="get_app_launch_configuration",
        op_kwargs={"appId": app_id},
    )


async def put(
    hub,
    ctx,
    app_id: str = None,
    role_name: str = None,
    auto_launch: bool = None,
    server_group_launch_configurations: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates or updates the launch configuration for the specified application.

    Args:
        app_id(str, optional): The ID of the application. Defaults to None.
        role_name(str, optional): The name of service role in the customer's account that AWS CloudFormation uses to launch the application. Defaults to None.
        auto_launch(bool, optional): Indicates whether the application is configured to launch automatically after replication is complete. Defaults to None.
        server_group_launch_configurations(List, optional): Information about the launch configurations for server groups in the application. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sms.app.launch_configuration.put(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sms.app.launch_configuration.put
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sms",
        operation="put_app_launch_configuration",
        op_kwargs={
            "appId": app_id,
            "roleName": role_name,
            "autoLaunch": auto_launch,
            "serverGroupLaunchConfigurations": server_group_launch_configurations,
        },
    )
