"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    name: str = None,
    description: str = None,
    role_name: str = None,
    client_token: str = None,
    server_groups: List = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an application. An application consists of one or more server groups. Each server group contain one or more servers.

    Args:
        name(str, optional): The name of the new application. Defaults to None.
        description(str, optional): The description of the new application. Defaults to None.
        role_name(str, optional): The name of the service role in the customer's account to be used by AWS SMS. Defaults to None.
        client_token(str, optional): A unique, case-sensitive identifier that you provide to ensure the idempotency of application creation. Defaults to None.
        server_groups(List, optional): The server groups to include in the application. Defaults to None.
        tags(List, optional): The tags to be associated with the application. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sms.app.init.create(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sms.app.init.create
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sms",
        operation="create_app",
        op_kwargs={
            "name": name,
            "description": description,
            "roleName": role_name,
            "clientToken": client_token,
            "serverGroups": server_groups,
            "tags": tags,
        },
    )


async def delete(
    hub,
    ctx,
    app_id: str = None,
    force_stop_app_replication: bool = None,
    force_terminate_app: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified application. Optionally deletes the launched stack associated with the application and all AWS SMS replication jobs for servers in the application.

    Args:
        app_id(str, optional): The ID of the application. Defaults to None.
        force_stop_app_replication(bool, optional): Indicates whether to stop all replication jobs corresponding to the servers in the application while deleting the application. Defaults to None.
        force_terminate_app(bool, optional): Indicates whether to terminate the stack corresponding to the application while deleting the application. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sms.app.init.delete(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sms.app.init.delete
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sms",
        operation="delete_app",
        op_kwargs={
            "appId": app_id,
            "forceStopAppReplication": force_stop_app_replication,
            "forceTerminateApp": force_terminate_app,
        },
    )


async def get(hub, ctx, app_id: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Retrieve information about the specified application.

    Args:
        app_id(str, optional): The ID of the application. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sms.app.init.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sms.app.init.get
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="sms", operation="get_app", op_kwargs={"appId": app_id}
    )


async def launch(hub, ctx, app_id: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Launches the specified application as a stack in AWS CloudFormation.

    Args:
        app_id(str, optional): The ID of the application. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sms.app.init.launch(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sms.app.init.launch
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="sms", operation="launch_app", op_kwargs={"appId": app_id}
    )


async def terminate(hub, ctx, app_id: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Terminates the stack for the specified application.

    Args:
        app_id(str, optional): The ID of the application. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sms.app.init.terminate(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sms.app.init.terminate
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="sms", operation="terminate_app", op_kwargs={"appId": app_id}
    )


async def update(
    hub,
    ctx,
    app_id: str = None,
    name: str = None,
    description: str = None,
    role_name: str = None,
    server_groups: List = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the specified application.

    Args:
        app_id(str, optional): The ID of the application. Defaults to None.
        name(str, optional): The new name of the application. Defaults to None.
        description(str, optional): The new description of the application. Defaults to None.
        role_name(str, optional): The name of the service role in the customer's account used by AWS SMS. Defaults to None.
        server_groups(List, optional): The server groups in the application to update. Defaults to None.
        tags(List, optional): The tags to associate with the application. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sms.app.init.update(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sms.app.init.update
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sms",
        operation="update_app",
        op_kwargs={
            "appId": app_id,
            "name": name,
            "description": description,
            "roleName": role_name,
            "serverGroups": server_groups,
            "tags": tags,
        },
    )
