"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def cancel(hub, ctx, profile_name: str) -> None:
    r"""
    **Autogenerated function**

    Changes the state of an ACTIVE signing profile to CANCELED. A canceled profile is still viewable with the ListSigningProfiles operation, but it cannot perform new signing jobs, and is deleted two years after cancelation.

    Args:
        profile_name(str): The name of the signing profile to be canceled.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.signer.signing.profile.cancel(ctx, profile_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.signer.signing.profile.cancel profile_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="signer",
        operation="cancel_signing_profile",
        op_kwargs={"profileName": profile_name},
    )


async def get(hub, ctx, profile_name: str, profile_owner: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns information on a specific signing profile.

    Args:
        profile_name(str): The name of the target signing profile.
        profile_owner(str, optional): The AWS account ID of the profile owner. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.signer.signing.profile.get(ctx, profile_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.signer.signing.profile.get profile_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="signer",
        operation="get_signing_profile",
        op_kwargs={"profileName": profile_name, "profileOwner": profile_owner},
    )


async def list_all(
    hub,
    ctx,
    include_canceled: bool = None,
    max_results: int = None,
    next_token: str = None,
    platform_id: str = None,
    statuses: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists all available signing profiles in your AWS account. Returns only profiles with an ACTIVE status unless the includeCanceled request field is set to true. If additional jobs remain to be listed, code signing returns a nextToken value. Use this value in subsequent calls to ListSigningJobs to fetch the remaining values. You can continue calling ListSigningJobs with your maxResults parameter and with new values that code signing returns in the nextToken parameter until all of your signing jobs have been returned.

    Args:
        include_canceled(bool, optional): Designates whether to include profiles with the status of CANCELED. Defaults to None.
        max_results(int, optional): The maximum number of profiles to be returned. Defaults to None.
        next_token(str, optional): Value for specifying the next set of paginated results to return. After you receive a response with truncated results, use this parameter in a subsequent request. Set it to the value of nextToken from the response that you just received. Defaults to None.
        platform_id(str, optional): Filters results to return only signing jobs initiated for a specified signing platform. Defaults to None.
        statuses(List, optional): Filters results to return only signing jobs with statuses in the specified list. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.signer.signing.profile.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.signer.signing.profile.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="signer",
        operation="list_signing_profiles",
        op_kwargs={
            "includeCanceled": include_canceled,
            "maxResults": max_results,
            "nextToken": next_token,
            "platformId": platform_id,
            "statuses": statuses,
        },
    )


async def put(
    hub,
    ctx,
    profile_name: str,
    platform_id: str,
    signing_material: Dict = None,
    signature_validity_period: Dict = None,
    overrides: Dict = None,
    signing_parameters: Dict = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a signing profile. A signing profile is a code signing template that can be used to carry out a pre-defined signing job. For more information, see http://docs.aws.amazon.com/signer/latest/developerguide/gs-profile.html

    Args:
        profile_name(str): The name of the signing profile to be created.
        signing_material(Dict, optional): The AWS Certificate Manager certificate that will be used to sign code with the new signing profile. Defaults to None.
        signature_validity_period(Dict, optional): The default validity period override for any signature generated using this signing profile. If unspecified, the default is 135 months. Defaults to None.
        platform_id(str): The ID of the signing platform to be created.
        overrides(Dict, optional): A subfield of platform. This specifies any different configuration options that you want to apply to the chosen platform (such as a different hash-algorithm or signing-algorithm). Defaults to None.
        signing_parameters(Dict, optional): Map of key-value pairs for signing. These can include any information that you want to use during signing. Defaults to None.
        tags(Dict, optional): Tags to be associated with the signing profile that is being created. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.signer.signing.profile.put(
                ctx, profile_name=value, platform_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.signer.signing.profile.put profile_name=value, platform_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="signer",
        operation="put_signing_profile",
        op_kwargs={
            "profileName": profile_name,
            "signingMaterial": signing_material,
            "signatureValidityPeriod": signature_validity_period,
            "platformId": platform_id,
            "overrides": overrides,
            "signingParameters": signing_parameters,
            "tags": tags,
        },
    )


async def revoke(
    hub, ctx, profile_name: str, profile_version: str, reason: str, effective_time: str
) -> None:
    r"""
    **Autogenerated function**

    Changes the state of a signing profile to REVOKED. This indicates that signatures generated using the signing profile after an effective start date are no longer valid.

    Args:
        profile_name(str): The name of the signing profile to be revoked.
        profile_version(str): The version of the signing profile to be revoked.
        reason(str): The reason for revoking a signing profile.
        effective_time(str): A timestamp for when revocation of a Signing Profile should become effective. Signatures generated using the signing profile after this timestamp are not trusted.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.signer.signing.profile.revoke(
                ctx, profile_name=value, profile_version=value, reason=value, effective_time=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.signer.signing.profile.revoke profile_name=value, profile_version=value, reason=value, effective_time=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="signer",
        operation="revoke_signing_profile",
        op_kwargs={
            "profileName": profile_name,
            "profileVersion": profile_version,
            "reason": reason,
            "effectiveTime": effective_time,
        },
    )
