"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx, job_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about a specific code signing job. You specify the job by using the jobId value that is returned by the StartSigningJob operation.

    Args:
        job_id(str): The ID of the signing job on input.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.signer.signing.job.describe(ctx, job_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.signer.signing.job.describe job_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="signer",
        operation="describe_signing_job",
        op_kwargs={"jobId": job_id},
    )


async def list_all(
    hub,
    ctx,
    status: str = None,
    platform_id: str = None,
    requested_by: str = None,
    max_results: int = None,
    next_token: str = None,
    is_revoked: bool = None,
    signature_expires_before: str = None,
    signature_expires_after: str = None,
    job_invoker: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists all your signing jobs. You can use the maxResults parameter to limit the number of signing jobs that are returned in the response. If additional jobs remain to be listed, code signing returns a nextToken value. Use this value in subsequent calls to ListSigningJobs to fetch the remaining values. You can continue calling ListSigningJobs with your maxResults parameter and with new values that code signing returns in the nextToken parameter until all of your signing jobs have been returned.

    Args:
        status(str, optional): A status value with which to filter your results. Defaults to None.
        platform_id(str, optional): The ID of microcontroller platform that you specified for the distribution of your code image. Defaults to None.
        requested_by(str, optional): The IAM principal that requested the signing job. Defaults to None.
        max_results(int, optional): Specifies the maximum number of items to return in the response. Use this parameter when paginating results. If additional items exist beyond the number you specify, the nextToken element is set in the response. Use the nextToken value in a subsequent request to retrieve additional items. . Defaults to None.
        next_token(str, optional): String for specifying the next set of paginated results to return. After you receive a response with truncated results, use this parameter in a subsequent request. Set it to the value of nextToken from the response that you just received. Defaults to None.
        is_revoked(bool, optional): Filters results to return only signing jobs with revoked signatures. Defaults to None.
        signature_expires_before(str, optional): Filters results to return only signing jobs with signatures expiring before a specified timestamp. Defaults to None.
        signature_expires_after(str, optional): Filters results to return only signing jobs with signatures expiring after a specified timestamp. Defaults to None.
        job_invoker(str, optional): Filters results to return only signing jobs initiated by a specified IAM entity. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.signer.signing.job.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.signer.signing.job.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="signer",
        operation="list_signing_jobs",
        op_kwargs={
            "status": status,
            "platformId": platform_id,
            "requestedBy": requested_by,
            "maxResults": max_results,
            "nextToken": next_token,
            "isRevoked": is_revoked,
            "signatureExpiresBefore": signature_expires_before,
            "signatureExpiresAfter": signature_expires_after,
            "jobInvoker": job_invoker,
        },
    )


async def start(
    hub,
    ctx,
    source: Dict,
    destination: Dict,
    profile_name: str,
    client_request_token: str,
    profile_owner: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Initiates a signing job to be performed on the code provided. Signing jobs are viewable by the ListSigningJobs operation for two years after they are performed. Note the following requirements:     You must create an Amazon S3 source bucket. For more information, see Create a Bucket in the Amazon S3 Getting Started Guide.    Your S3 source bucket must be version enabled.   You must create an S3 destination bucket. Code signing uses your S3 destination bucket to write your signed code.   You specify the name of the source and destination buckets when calling the StartSigningJob operation.   You must also specify a request token that identifies your request to code signing.   You can call the DescribeSigningJob and the ListSigningJobs actions after you call StartSigningJob. For a Java example that shows how to use this action, see http://docs.aws.amazon.com/acm/latest/userguide/

    Args:
        source(Dict): The S3 bucket that contains the object to sign or a BLOB that contains your raw code.
        destination(Dict): The S3 bucket in which to save your signed object. The destination contains the name of your bucket and an optional prefix.
        profile_name(str): The name of the signing profile.
        client_request_token(str): String that identifies the signing request. All calls after the first that use this token return the same response as the first call.
        profile_owner(str, optional): The AWS account ID of the signing profile owner. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.signer.signing.job.start(
                ctx, source=value, destination=value, profile_name=value, client_request_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.signer.signing.job.start source=value, destination=value, profile_name=value, client_request_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="signer",
        operation="start_signing_job",
        op_kwargs={
            "source": source,
            "destination": destination,
            "profileName": profile_name,
            "clientRequestToken": client_request_token,
            "profileOwner": profile_owner,
        },
    )
