"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def add(
    hub,
    ctx,
    profile_name: str,
    action: str,
    principal: str,
    statement_id: str,
    profile_version: str = None,
    revision_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Adds cross-account permissions to a signing profile.

    Args:
        profile_name(str): The human-readable name of the signing profile.
        profile_version(str, optional): The version of the signing profile. Defaults to None.
        action(str): The AWS Signer action permitted as part of cross-account permissions.
        principal(str): The AWS principal receiving cross-account permissions. This may be an IAM role or another AWS account ID.
        revision_id(str, optional): A unique identifier for the current profile revision. Defaults to None.
        statement_id(str): A unique identifier for the cross-account permission statement.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.signer.profile_permission.add(
                ctx, profile_name=value, action=value, principal=value, statement_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.signer.profile_permission.add profile_name=value, action=value, principal=value, statement_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="signer",
        operation="add_profile_permission",
        op_kwargs={
            "profileName": profile_name,
            "profileVersion": profile_version,
            "action": action,
            "principal": principal,
            "revisionId": revision_id,
            "statementId": statement_id,
        },
    )


async def list_all(hub, ctx, profile_name: str, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists the cross-account permissions associated with a signing profile.

    Args:
        profile_name(str): Name of the signing profile containing the cross-account permissions.
        next_token(str, optional): String for specifying the next set of paginated results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.signer.profile_permission.list_all(ctx, profile_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.signer.profile_permission.list_all profile_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="signer",
        operation="list_profile_permissions",
        op_kwargs={"profileName": profile_name, "nextToken": next_token},
    )


async def remove(
    hub, ctx, profile_name: str, revision_id: str, statement_id: str
) -> Dict:
    r"""
    **Autogenerated function**

    Removes cross-account permissions from a signing profile.

    Args:
        profile_name(str): A human-readable name for the signing profile with permissions to be removed.
        revision_id(str): An identifier for the current revision of the signing profile permissions.
        statement_id(str): A unique identifier for the cross-account permissions statement.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.signer.profile_permission.remove(
                ctx, profile_name=value, revision_id=value, statement_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.signer.profile_permission.remove profile_name=value, revision_id=value, statement_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="signer",
        operation="remove_profile_permission",
        op_kwargs={
            "profileName": profile_name,
            "revisionId": revision_id,
            "statementId": statement_id,
        },
    )
