"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Activates Shield Advanced for an account. When you initally create a subscription, your subscription is set to be automatically renewed at the end of the existing subscription period. You can change this by submitting an UpdateSubscription request.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.shield.subscription.init.create(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.shield.subscription.init.create
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="shield", operation="create_subscription", op_kwargs={}
    )


async def delete(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Removes Shield Advanced from an account. Shield Advanced requires a 1-year subscription commitment. You cannot delete a subscription prior to the completion of that commitment.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.shield.subscription.init.delete(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.shield.subscription.init.delete
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="shield", operation="delete_subscription", op_kwargs={}
    )


async def describe(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Provides details about the Shield Advanced subscription for an account.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.shield.subscription.init.describe(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.shield.subscription.init.describe
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="shield", operation="describe_subscription", op_kwargs={}
    )


async def update(hub, ctx, auto_renew: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Updates the details of an existing subscription. Only enter values for parameters you want to change. Empty parameters are not updated.

    Args:
        auto_renew(str, optional): When you initally create a subscription, AutoRenew is set to ENABLED. If ENABLED, the subscription will be automatically renewed at the end of the existing subscription period. You can change this by submitting an UpdateSubscription request. If the UpdateSubscription request does not included a value for AutoRenew, the existing value for AutoRenew remains unchanged. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.shield.subscription.init.update(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.shield.subscription.init.update
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="shield",
        operation="update_subscription",
        op_kwargs={"AutoRenew": auto_renew},
    )
