"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub, ctx, protection_group_id: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the resources that are included in the protection group.

    Args:
        protection_group_id(str): The name of the protection group. You use this to identify the protection group in lists and to manage the protection group, for example to update, delete, or describe it. .
        next_token(str, optional): The next token value from a previous call to ListResourcesInProtectionGroup. Pass null if this is the first call. Defaults to None.
        max_results(int, optional): The maximum number of resource ARN objects to return. If you leave this blank, Shield Advanced returns the first 20 results. This is a maximum value. Shield Advanced might return the results in smaller batches. That is, the number of objects returned could be less than MaxResults, even if there are still more objects yet to return. If there are more objects to return, Shield Advanced returns a value in NextToken that you can use in your next request, to get the next batch of objects. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.shield.resource.in_protection_group.list(
                ctx, protection_group_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.shield.resource.in_protection_group.list protection_group_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="shield",
        operation="list_resources_in_protection_group",
        op_kwargs={
            "ProtectionGroupId": protection_group_id,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
