"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(hub, ctx, name: str, resource_arn: str, tags: List = None) -> Dict:
    r"""
    **Autogenerated function**

    Enables Shield Advanced for a specific Amazon Web Services resource. The resource can be an Amazon CloudFront distribution, Elastic Load Balancing load balancer, Global Accelerator accelerator, Elastic IP Address, or an Amazon Route 53 hosted zone. You can add protection to only a single resource with each CreateProtection request. If you want to add protection to multiple resources at once, use the WAF console. For more information see Getting Started with Shield Advanced and Add Shield Advanced Protection to more Amazon Web Services Resources.

    Args:
        name(str): Friendly name for the Protection you are creating.
        resource_arn(str): The ARN (Amazon Resource Name) of the resource to be protected. The ARN should be in one of the following formats:   For an Application Load Balancer: arn:aws:elasticloadbalancing:region:account-id:loadbalancer/app/load-balancer-name/load-balancer-id     For an Elastic Load Balancer (Classic Load Balancer): arn:aws:elasticloadbalancing:region:account-id:loadbalancer/load-balancer-name     For an Amazon CloudFront distribution: arn:aws:cloudfront::account-id:distribution/distribution-id     For an Global Accelerator accelerator: arn:aws:globalaccelerator::account-id:accelerator/accelerator-id     For Amazon Route 53: arn:aws:route53:::hostedzone/hosted-zone-id     For an Elastic IP address: arn:aws:ec2:region:account-id:eip-allocation/allocation-id    .
        tags(List, optional): One or more tag key-value pairs for the Protection object that is created. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.shield.protection.init.create(
                ctx, name=value, resource_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.shield.protection.init.create name=value, resource_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="shield",
        operation="create_protection",
        op_kwargs={"Name": name, "ResourceArn": resource_arn, "Tags": tags},
    )


async def delete(hub, ctx, protection_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an Shield Advanced Protection.

    Args:
        protection_id(str): The unique identifier (ID) for the Protection object to be deleted.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.shield.protection.init.delete(ctx, protection_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.shield.protection.init.delete protection_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="shield",
        operation="delete_protection",
        op_kwargs={"ProtectionId": protection_id},
    )


async def describe(
    hub, ctx, protection_id: str = None, resource_arn: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the details of a Protection object.

    Args:
        protection_id(str, optional): The unique identifier (ID) for the Protection object that is described. When submitting the DescribeProtection request you must provide either the ResourceArn or the ProtectionID, but not both. Defaults to None.
        resource_arn(str, optional): The ARN (Amazon Resource Name) of the Amazon Web Services resource for the Protection object that is described. When submitting the DescribeProtection request you must provide either the ResourceArn or the ProtectionID, but not both. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.shield.protection.init.describe(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.shield.protection.init.describe
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="shield",
        operation="describe_protection",
        op_kwargs={"ProtectionId": protection_id, "ResourceArn": resource_arn},
    )


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists all Protection objects for the account.

    Args:
        next_token(str, optional): The ListProtectionsRequest.NextToken value from a previous call to ListProtections. Pass null if this is the first call. Defaults to None.
        max_results(int, optional): The maximum number of Protection objects to return. If you leave this blank, Shield Advanced returns the first 20 results. This is a maximum value. Shield Advanced might return the results in smaller batches. That is, the number of objects returned could be less than MaxResults, even if there are still more objects yet to return. If there are more objects to return, Shield Advanced returns a value in NextToken that you can use in your next request, to get the next batch of objects. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.shield.protection.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.shield.protection.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="shield",
        operation="list_protections",
        op_kwargs={"NextToken": next_token, "MaxResults": max_results},
    )
