"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    protection_group_id: str,
    aggregation: str,
    pattern: str,
    resource_type: str = None,
    members: List = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a grouping of protected resources so they can be handled as a collective. This resource grouping improves the accuracy of detection and reduces false positives.

    Args:
        protection_group_id(str): The name of the protection group. You use this to identify the protection group in lists and to manage the protection group, for example to update, delete, or describe it. .
        aggregation(str): Defines how Shield combines resource data for the group in order to detect, mitigate, and report events.   Sum - Use the total traffic across the group. This is a good choice for most cases. Examples include Elastic IP addresses for EC2 instances that scale manually or automatically.   Mean - Use the average of the traffic across the group. This is a good choice for resources that share traffic uniformly. Examples include accelerators and load balancers.   Max - Use the highest traffic from each resource. This is useful for resources that don't share traffic and for resources that share that traffic in a non-uniform way. Examples include Amazon CloudFront and origin resources for CloudFront distributions.  .
        pattern(str): The criteria to use to choose the protected resources for inclusion in the group. You can include all resources that have protections, provide a list of resource Amazon Resource Names (ARNs), or include all resources of a specified resource type. .
        resource_type(str, optional): The resource type to include in the protection group. All protected resources of this type are included in the protection group. Newly protected resources of this type are automatically added to the group. You must set this when you set Pattern to BY_RESOURCE_TYPE and you must not set it for any other Pattern setting. . Defaults to None.
        members(List, optional): The Amazon Resource Names (ARNs) of the resources to include in the protection group. You must set this when you set Pattern to ARBITRARY and you must not set it for any other Pattern setting. . Defaults to None.
        tags(List, optional): One or more tag key-value pairs for the protection group. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.shield.protection.group.create(
                ctx, protection_group_id=value, aggregation=value, pattern=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.shield.protection.group.create protection_group_id=value, aggregation=value, pattern=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="shield",
        operation="create_protection_group",
        op_kwargs={
            "ProtectionGroupId": protection_group_id,
            "Aggregation": aggregation,
            "Pattern": pattern,
            "ResourceType": resource_type,
            "Members": members,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, protection_group_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Removes the specified protection group.

    Args:
        protection_group_id(str): The name of the protection group. You use this to identify the protection group in lists and to manage the protection group, for example to update, delete, or describe it. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.shield.protection.group.delete(ctx, protection_group_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.shield.protection.group.delete protection_group_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="shield",
        operation="delete_protection_group",
        op_kwargs={"ProtectionGroupId": protection_group_id},
    )


async def describe(hub, ctx, protection_group_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns the specification for the specified protection group.

    Args:
        protection_group_id(str): The name of the protection group. You use this to identify the protection group in lists and to manage the protection group, for example to update, delete, or describe it. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.shield.protection.group.describe(ctx, protection_group_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.shield.protection.group.describe protection_group_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="shield",
        operation="describe_protection_group",
        op_kwargs={"ProtectionGroupId": protection_group_id},
    )


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the ProtectionGroup objects for the account.

    Args:
        next_token(str, optional): The next token value from a previous call to ListProtectionGroups. Pass null if this is the first call. Defaults to None.
        max_results(int, optional): The maximum number of ProtectionGroup objects to return. If you leave this blank, Shield Advanced returns the first 20 results. This is a maximum value. Shield Advanced might return the results in smaller batches. That is, the number of objects returned could be less than MaxResults, even if there are still more objects yet to return. If there are more objects to return, Shield Advanced returns a value in NextToken that you can use in your next request, to get the next batch of objects. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.shield.protection.group.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.shield.protection.group.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="shield",
        operation="list_protection_groups",
        op_kwargs={"NextToken": next_token, "MaxResults": max_results},
    )


async def update(
    hub,
    ctx,
    protection_group_id: str,
    aggregation: str,
    pattern: str,
    resource_type: str = None,
    members: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates an existing protection group. A protection group is a grouping of protected resources so they can be handled as a collective. This resource grouping improves the accuracy of detection and reduces false positives.

    Args:
        protection_group_id(str): The name of the protection group. You use this to identify the protection group in lists and to manage the protection group, for example to update, delete, or describe it. .
        aggregation(str): Defines how Shield combines resource data for the group in order to detect, mitigate, and report events.   Sum - Use the total traffic across the group. This is a good choice for most cases. Examples include Elastic IP addresses for EC2 instances that scale manually or automatically.   Mean - Use the average of the traffic across the group. This is a good choice for resources that share traffic uniformly. Examples include accelerators and load balancers.   Max - Use the highest traffic from each resource. This is useful for resources that don't share traffic and for resources that share that traffic in a non-uniform way. Examples include Amazon CloudFront distributions and origin resources for CloudFront distributions.  .
        pattern(str): The criteria to use to choose the protected resources for inclusion in the group. You can include all resources that have protections, provide a list of resource Amazon Resource Names (ARNs), or include all resources of a specified resource type.
        resource_type(str, optional): The resource type to include in the protection group. All protected resources of this type are included in the protection group. You must set this when you set Pattern to BY_RESOURCE_TYPE and you must not set it for any other Pattern setting. . Defaults to None.
        members(List, optional): The Amazon Resource Names (ARNs) of the resources to include in the protection group. You must set this when you set Pattern to ARBITRARY and you must not set it for any other Pattern setting. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.shield.protection.group.update(
                ctx, protection_group_id=value, aggregation=value, pattern=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.shield.protection.group.update protection_group_id=value, aggregation=value, pattern=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="shield",
        operation="update_protection_group",
        op_kwargs={
            "ProtectionGroupId": protection_group_id,
            "Aggregation": aggregation,
            "Pattern": pattern,
            "ResourceType": resource_type,
            "Members": members,
        },
    )
