"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def disable(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Removes authorization from the Shield Response Team (SRT) to notify contacts about escalations to the SRT and to initiate proactive customer support.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.shield.proactive_engagement.init.disable(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.shield.proactive_engagement.init.disable
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="shield",
        operation="disable_proactive_engagement",
        op_kwargs={},
    )


async def enable(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Authorizes the Shield Response Team (SRT) to use email and phone to notify contacts about escalations to the SRT and to initiate proactive customer support.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.shield.proactive_engagement.init.enable(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.shield.proactive_engagement.init.enable
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="shield",
        operation="enable_proactive_engagement",
        op_kwargs={},
    )
