"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def associate(hub, ctx, emergency_contact_list: List) -> Dict:
    r"""
    **Autogenerated function**

    Initializes proactive engagement and sets the list of contacts for the Shield Response Team (SRT) to use. You must provide at least one phone number in the emergency contact list.  After you have initialized proactive engagement using this call, to disable or enable proactive engagement, use the calls DisableProactiveEngagement and EnableProactiveEngagement.   This call defines the list of email addresses and phone numbers that the SRT can use to contact you for escalations to the SRT and to initiate proactive customer support. The contacts that you provide in the request replace any contacts that were already defined. If you already have contacts defined and want to use them, retrieve the list using DescribeEmergencyContactSettings and then provide it to this call.

    Args:
        emergency_contact_list(List): A list of email addresses and phone numbers that the Shield Response Team (SRT) can use to contact you for escalations to the SRT and to initiate proactive customer support.  To enable proactive engagement, the contact list must include at least one phone number.  The contacts that you provide here replace any contacts that were already defined. If you already have contacts defined and want to use them, retrieve the list using DescribeEmergencyContactSettings and then provide it here.  .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.shield.proactive_engagement.detail.associate(
                ctx, emergency_contact_list=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.shield.proactive_engagement.detail.associate emergency_contact_list=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="shield",
        operation="associate_proactive_engagement_details",
        op_kwargs={"EmergencyContactList": emergency_contact_list},
    )
