"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def associate(hub, ctx, protection_id: str, health_check_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Adds health-based detection to the Shield Advanced protection for a resource. Shield Advanced health-based detection uses the health of your Amazon Web Services resource to improve responsiveness and accuracy in attack detection and mitigation.  You define the health check in Route 53 and then associate it with your Shield Advanced protection. For more information, see Shield Advanced Health-Based Detection in the WAF Developer Guide.

    Args:
        protection_id(str): The unique identifier (ID) for the Protection object to add the health check association to. .
        health_check_arn(str): The Amazon Resource Name (ARN) of the health check to associate with the protection.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.shield.health_check.associate(
                ctx, protection_id=value, health_check_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.shield.health_check.associate protection_id=value, health_check_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="shield",
        operation="associate_health_check",
        op_kwargs={"ProtectionId": protection_id, "HealthCheckArn": health_check_arn},
    )


async def disassociate(hub, ctx, protection_id: str, health_check_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Removes health-based detection from the Shield Advanced protection for a resource. Shield Advanced health-based detection uses the health of your Amazon Web Services resource to improve responsiveness and accuracy in attack detection and mitigation.  You define the health check in Route 53 and then associate or disassociate it with your Shield Advanced protection. For more information, see Shield Advanced Health-Based Detection in the WAF Developer Guide.

    Args:
        protection_id(str): The unique identifier (ID) for the Protection object to remove the health check association from. .
        health_check_arn(str): The Amazon Resource Name (ARN) of the health check that is associated with the protection.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.shield.health_check.disassociate(
                ctx, protection_id=value, health_check_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.shield.health_check.disassociate protection_id=value, health_check_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="shield",
        operation="disassociate_health_check",
        op_kwargs={"ProtectionId": protection_id, "HealthCheckArn": health_check_arn},
    )
