"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    A list of email addresses and phone numbers that the Shield Response Team (SRT) can use to contact you if you have proactive engagement enabled, for escalations to the SRT and to initiate proactive customer support.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.shield.emergency_contact_setting.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.shield.emergency_contact_setting.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="shield",
        operation="describe_emergency_contact_settings",
        op_kwargs={},
    )


async def update_multiple(hub, ctx, emergency_contact_list: List = None) -> Dict:
    r"""
    **Autogenerated function**

    Updates the details of the list of email addresses and phone numbers that the Shield Response Team (SRT) can use to contact you if you have proactive engagement enabled, for escalations to the SRT and to initiate proactive customer support.

    Args:
        emergency_contact_list(List, optional): A list of email addresses and phone numbers that the Shield Response Team (SRT) can use to contact you if you have proactive engagement enabled, for escalations to the SRT and to initiate proactive customer support. If you have proactive engagement enabled, the contact list must include at least one phone number. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.shield.emergency_contact_setting.update_multiple(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.shield.emergency_contact_setting.update_multiple
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="shield",
        operation="update_emergency_contact_settings",
        op_kwargs={"EmergencyContactList": emergency_contact_list},
    )
