"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def associate(hub, ctx, log_bucket: str) -> Dict:
    r"""
    **Autogenerated function**

    Authorizes the Shield Response Team (SRT) to access the specified Amazon S3 bucket containing log data such as Application Load Balancer access logs, CloudFront logs, or logs from third party sources. You can associate up to 10 Amazon S3 buckets with your subscription. To use the services of the SRT and make an AssociateDRTLogBucket request, you must be subscribed to the Business Support plan or the Enterprise Support plan.

    Args:
        log_bucket(str): The Amazon S3 bucket that contains the logs that you want to share.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.shield.drt.log_bucket.associate(ctx, log_bucket=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.shield.drt.log_bucket.associate log_bucket=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="shield",
        operation="associate_drt_log_bucket",
        op_kwargs={"LogBucket": log_bucket},
    )


async def disassociate(hub, ctx, log_bucket: str) -> Dict:
    r"""
    **Autogenerated function**

    Removes the Shield Response Team's (SRT) access to the specified Amazon S3 bucket containing the logs that you shared previously. To make a DisassociateDRTLogBucket request, you must be subscribed to the Business Support plan or the Enterprise Support plan. However, if you are not subscribed to one of these support plans, but had been previously and had granted the SRT access to your account, you can submit a DisassociateDRTLogBucket request to remove this access.

    Args:
        log_bucket(str): The Amazon S3 bucket that contains the logs that you want to share.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.shield.drt.log_bucket.disassociate(ctx, log_bucket=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.shield.drt.log_bucket.disassociate log_bucket=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="shield",
        operation="disassociate_drt_log_bucket",
        op_kwargs={"LogBucket": log_bucket},
    )
