"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Returns the current role and list of Amazon S3 log buckets used by the Shield Response Team (SRT) to access your Amazon Web Services account while assisting with attack mitigation.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.shield.drt.access.describe(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.shield.drt.access.describe
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="shield", operation="describe_drt_access", op_kwargs={}
    )
