"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def test(hub, ctx, template_name: str, template_data: str) -> Dict:
    r"""
    **Autogenerated function**

    Creates a preview of the MIME content of an email when provided with a template and a set of replacement data. You can execute this operation no more than once per second.

    Args:
        template_name(str): The name of the template that you want to render.
        template_data(str): A list of replacement values to apply to the template. This parameter is a JSON object, typically consisting of key-value pairs in which the keys correspond to replacement tags in the email template.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sesv2.render_email_template.test(
                ctx, template_name=value, template_data=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sesv2.render_email_template.test template_name=value, template_data=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sesv2",
        operation="test_render_email_template",
        op_kwargs={"TemplateName": template_name, "TemplateData": template_data},
    )
