"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, import_destination: Dict, import_data_source: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Creates an import job for a data destination.

    Args:
        import_destination(Dict): The destination for the import job.
        import_data_source(Dict): The data source for the import job.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sesv2.import_job.create(
                ctx, import_destination=value, import_data_source=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sesv2.import_job.create import_destination=value, import_data_source=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sesv2",
        operation="create_import_job",
        op_kwargs={
            "ImportDestination": import_destination,
            "ImportDataSource": import_data_source,
        },
    )


async def get(hub, ctx, job_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Provides information about an import job.

    Args:
        job_id(str): The ID of the import job.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sesv2.import_job.get(ctx, job_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sesv2.import_job.get job_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sesv2",
        operation="get_import_job",
        op_kwargs={"JobId": job_id},
    )


async def list_all(
    hub,
    ctx,
    import_destination_type: str = None,
    next_token: str = None,
    page_size: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists all of the import jobs.

    Args:
        import_destination_type(str, optional): The destination of the import job, which can be used to list import jobs that have a certain ImportDestinationType. Defaults to None.
        next_token(str, optional): A string token indicating that there might be additional import jobs available to be listed. Copy this token to a subsequent call to ListImportJobs with the same parameters to retrieve the next page of import jobs. Defaults to None.
        page_size(int, optional): Maximum number of import jobs to return at once. Use this parameter to paginate results. If additional import jobs exist beyond the specified limit, the NextToken element is sent in the response. Use the NextToken value in subsequent requests to retrieve additional addresses. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sesv2.import_job.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sesv2.import_job.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sesv2",
        operation="list_import_jobs",
        op_kwargs={
            "ImportDestinationType": import_destination_type,
            "NextToken": next_token,
            "PageSize": page_size,
        },
    )
