"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, template_name: str, template_content: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Creates an email template. Email templates enable you to send personalized email to one or more destinations in a single API operation. For more information, see the Amazon SES Developer Guide. You can execute this operation no more than once per second.

    Args:
        template_name(str): The name of the template you want to create.
        template_content(Dict): The content of the email template, composed of a subject line, an HTML part, and a text-only part.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sesv2.email.template.create(
                ctx, template_name=value, template_content=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sesv2.email.template.create template_name=value, template_content=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sesv2",
        operation="create_email_template",
        op_kwargs={"TemplateName": template_name, "TemplateContent": template_content},
    )


async def delete(hub, ctx, template_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an email template. You can execute this operation no more than once per second.

    Args:
        template_name(str): The name of the template to be deleted.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sesv2.email.template.delete(ctx, template_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sesv2.email.template.delete template_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sesv2",
        operation="delete_email_template",
        op_kwargs={"TemplateName": template_name},
    )


async def get(hub, ctx, template_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Displays the template object (which includes the subject line, HTML part and text part) for the template you specify. You can execute this operation no more than once per second.

    Args:
        template_name(str): The name of the template you want to retrieve.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sesv2.email.template.get(ctx, template_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sesv2.email.template.get template_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sesv2",
        operation="get_email_template",
        op_kwargs={"TemplateName": template_name},
    )


async def list_all(hub, ctx, next_token: str = None, page_size: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists the email templates present in your Amazon SES account in the current AWS Region. You can execute this operation no more than once per second.

    Args:
        next_token(str, optional): A token returned from a previous call to ListEmailTemplates to indicate the position in the list of email templates. Defaults to None.
        page_size(int, optional): The number of results to show in a single call to ListEmailTemplates. If the number of results is larger than the number you specified in this parameter, then the response includes a NextToken element, which you can use to obtain additional results. The value you specify has to be at least 1, and can be no more than 10. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sesv2.email.template.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sesv2.email.template.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sesv2",
        operation="list_email_templates",
        op_kwargs={"NextToken": next_token, "PageSize": page_size},
    )


async def update(hub, ctx, template_name: str, template_content: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Updates an email template. Email templates enable you to send personalized email to one or more destinations in a single API operation. For more information, see the Amazon SES Developer Guide. You can execute this operation no more than once per second.

    Args:
        template_name(str): The name of the template you want to update.
        template_content(Dict): The content of the email template, composed of a subject line, an HTML part, and a text-only part.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sesv2.email.template.update(
                ctx, template_name=value, template_content=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sesv2.email.template.update template_name=value, template_content=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sesv2",
        operation="update_email_template",
        op_kwargs={"TemplateName": template_name, "TemplateContent": template_content},
    )
