"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, email_identity: str, policy_name: str, policy: str) -> Dict:
    r"""
    **Autogenerated function**

    Creates the specified sending authorization policy for the given identity (an email address or a domain).  This API is for the identity owner only. If you have not verified the identity, this API will return an error.  Sending authorization is a feature that enables an identity owner to authorize other senders to use its identities. For information about using sending authorization, see the Amazon SES Developer Guide. You can execute this operation no more than once per second.

    Args:
        email_identity(str): The email identity for which you want to create a policy.
        policy_name(str): The name of the policy. The policy name cannot exceed 64 characters and can only include alphanumeric characters, dashes, and underscores.
        policy(str): The text of the policy in JSON format. The policy cannot exceed 4 KB. For information about the syntax of sending authorization policies, see the Amazon SES Developer Guide.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sesv2.email.identity.policy.create(
                ctx, email_identity=value, policy_name=value, policy=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sesv2.email.identity.policy.create email_identity=value, policy_name=value, policy=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sesv2",
        operation="create_email_identity_policy",
        op_kwargs={
            "EmailIdentity": email_identity,
            "PolicyName": policy_name,
            "Policy": policy,
        },
    )


async def delete(hub, ctx, email_identity: str, policy_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified sending authorization policy for the given identity (an email address or a domain). This API returns successfully even if a policy with the specified name does not exist.  This API is for the identity owner only. If you have not verified the identity, this API will return an error.  Sending authorization is a feature that enables an identity owner to authorize other senders to use its identities. For information about using sending authorization, see the Amazon SES Developer Guide. You can execute this operation no more than once per second.

    Args:
        email_identity(str): The email identity for which you want to delete a policy.
        policy_name(str): The name of the policy. The policy name cannot exceed 64 characters and can only include alphanumeric characters, dashes, and underscores.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sesv2.email.identity.policy.delete(
                ctx, email_identity=value, policy_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sesv2.email.identity.policy.delete email_identity=value, policy_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sesv2",
        operation="delete_email_identity_policy",
        op_kwargs={"EmailIdentity": email_identity, "PolicyName": policy_name},
    )


async def get_all(hub, ctx, email_identity: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns the requested sending authorization policies for the given identity (an email address or a domain). The policies are returned as a map of policy names to policy contents. You can retrieve a maximum of 20 policies at a time.  This API is for the identity owner only. If you have not verified the identity, this API will return an error.  Sending authorization is a feature that enables an identity owner to authorize other senders to use its identities. For information about using sending authorization, see the Amazon SES Developer Guide. You can execute this operation no more than once per second.

    Args:
        email_identity(str): The email identity that you want to retrieve policies for.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sesv2.email.identity.policy.get_all(ctx, email_identity=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sesv2.email.identity.policy.get_all email_identity=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sesv2",
        operation="get_email_identity_policies",
        op_kwargs={"EmailIdentity": email_identity},
    )


async def update(hub, ctx, email_identity: str, policy_name: str, policy: str) -> Dict:
    r"""
    **Autogenerated function**

    Updates the specified sending authorization policy for the given identity (an email address or a domain). This API returns successfully even if a policy with the specified name does not exist.  This API is for the identity owner only. If you have not verified the identity, this API will return an error.  Sending authorization is a feature that enables an identity owner to authorize other senders to use its identities. For information about using sending authorization, see the Amazon SES Developer Guide. You can execute this operation no more than once per second.

    Args:
        email_identity(str): The email identity for which you want to update policy.
        policy_name(str): The name of the policy. The policy name cannot exceed 64 characters and can only include alphanumeric characters, dashes, and underscores.
        policy(str): The text of the policy in JSON format. The policy cannot exceed 4 KB.  For information about the syntax of sending authorization policies, see the Amazon SES Developer Guide.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sesv2.email.identity.policy.update(
                ctx, email_identity=value, policy_name=value, policy=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sesv2.email.identity.policy.update email_identity=value, policy_name=value, policy=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sesv2",
        operation="update_email_identity_policy",
        op_kwargs={
            "EmailIdentity": email_identity,
            "PolicyName": policy_name,
            "Policy": policy,
        },
    )
