"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def put_multiple(
    hub,
    ctx,
    email_identity: str,
    mail_from_domain: str = None,
    behavior_on_mx_failure: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Used to enable or disable the custom Mail-From domain configuration for an email identity.

    Args:
        email_identity(str): The verified email identity that you want to set up the custom MAIL FROM domain for.
        mail_from_domain(str, optional):  The custom MAIL FROM domain that you want the verified identity to use. The MAIL FROM domain must meet the following criteria:   It has to be a subdomain of the verified identity.   It can't be used to receive email.   It can't be used in a "From" address if the MAIL FROM domain is a destination for feedback forwarding emails.  . Defaults to None.
        behavior_on_mx_failure(str, optional): The action that you want to take if the required MX record isn't found when you send an email. When you set this value to UseDefaultValue, the mail is sent using amazonses.com as the MAIL FROM domain. When you set this value to RejectMessage, the Amazon SES API v2 returns a MailFromDomainNotVerified error, and doesn't attempt to deliver the email. These behaviors are taken when the custom MAIL FROM domain configuration is in the Pending, Failed, and TemporaryFailure states. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sesv2.email.identity.mail_from_attribute.put_multiple(
                ctx, email_identity=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sesv2.email.identity.mail_from_attribute.put_multiple email_identity=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sesv2",
        operation="put_email_identity_mail_from_attributes",
        op_kwargs={
            "EmailIdentity": email_identity,
            "MailFromDomain": mail_from_domain,
            "BehaviorOnMxFailure": behavior_on_mx_failure,
        },
    )
