"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    email_identity: str,
    tags: List = None,
    dkim_signing_attributes: Dict = None,
    configuration_set_name: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Starts the process of verifying an email identity. An identity is an email address or domain that you use when you send email. Before you can use an identity to send email, you first have to verify it. By verifying an identity, you demonstrate that you're the owner of the identity, and that you've given Amazon SES API v2 permission to send email from the identity. When you verify an email address, Amazon SES sends an email to the address. Your email address is verified as soon as you follow the link in the verification email.  When you verify a domain without specifying the DkimSigningAttributes object, this operation provides a set of DKIM tokens. You can convert these tokens into CNAME records, which you then add to the DNS configuration for your domain. Your domain is verified when Amazon SES detects these records in the DNS configuration for your domain. This verification method is known as Easy DKIM. Alternatively, you can perform the verification process by providing your own public-private key pair. This verification method is known as Bring Your Own DKIM (BYODKIM). To use BYODKIM, your call to the CreateEmailIdentity operation has to include the DkimSigningAttributes object. When you specify this object, you provide a selector (a component of the DNS record name that identifies the public key that you want to use for DKIM authentication) and a private key. When you verify a domain, this operation provides a set of DKIM tokens, which you can convert into CNAME tokens. You add these CNAME tokens to the DNS configuration for your domain. Your domain is verified when Amazon SES detects these records in the DNS configuration for your domain. For some DNS providers, it can take 72 hours or more to complete the domain verification process. Additionally, you can associate an existing configuration set with the email identity that you're verifying.

    Args:
        email_identity(str): The email address or domain that you want to verify.
        tags(List, optional): An array of objects that define the tags (keys and values) that you want to associate with the email identity. Defaults to None.
        dkim_signing_attributes(Dict, optional): If your request includes this object, Amazon SES configures the identity to use Bring Your Own DKIM (BYODKIM) for DKIM authentication purposes, as opposed to the default method, Easy DKIM. You can only specify this object if the email identity is a domain, as opposed to an address. Defaults to None.
        configuration_set_name(str, optional): The configuration set to use by default when sending from this identity. Note that any configuration set defined in the email sending request takes precedence. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sesv2.email.identity.init.create(ctx, email_identity=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sesv2.email.identity.init.create email_identity=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sesv2",
        operation="create_email_identity",
        op_kwargs={
            "EmailIdentity": email_identity,
            "Tags": tags,
            "DkimSigningAttributes": dkim_signing_attributes,
            "ConfigurationSetName": configuration_set_name,
        },
    )


async def delete(hub, ctx, email_identity: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an email identity. An identity can be either an email address or a domain name.

    Args:
        email_identity(str): The identity (that is, the email address or domain) that you want to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sesv2.email.identity.init.delete(ctx, email_identity=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sesv2.email.identity.init.delete email_identity=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sesv2",
        operation="delete_email_identity",
        op_kwargs={"EmailIdentity": email_identity},
    )


async def get(hub, ctx, email_identity: str) -> Dict:
    r"""
    **Autogenerated function**

    Provides information about a specific identity, including the identity's verification status, sending authorization policies, its DKIM authentication status, and its custom Mail-From settings.

    Args:
        email_identity(str): The email identity that you want to retrieve details for.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sesv2.email.identity.init.get(ctx, email_identity=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sesv2.email.identity.init.get email_identity=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sesv2",
        operation="get_email_identity",
        op_kwargs={"EmailIdentity": email_identity},
    )


async def list_all(hub, ctx, next_token: str = None, page_size: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of all of the email identities that are associated with your AWS account. An identity can be either an email address or a domain. This operation returns identities that are verified as well as those that aren't. This operation returns identities that are associated with Amazon SES and Amazon Pinpoint.

    Args:
        next_token(str, optional): A token returned from a previous call to ListEmailIdentities to indicate the position in the list of identities. Defaults to None.
        page_size(int, optional): The number of results to show in a single call to ListEmailIdentities. If the number of results is larger than the number you specified in this parameter, then the response includes a NextToken element, which you can use to obtain additional results. The value you specify has to be at least 0, and can be no more than 1000. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sesv2.email.identity.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sesv2.email.identity.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sesv2",
        operation="list_email_identities",
        op_kwargs={"NextToken": next_token, "PageSize": page_size},
    )
