"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def put_multiple(
    hub,
    ctx,
    email_identity: str,
    signing_attributes_origin: str,
    signing_attributes: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Used to configure or change the DKIM authentication settings for an email domain identity. You can use this operation to do any of the following:   Update the signing attributes for an identity that uses Bring Your Own DKIM (BYODKIM).   Change from using no DKIM authentication to using Easy DKIM.   Change from using no DKIM authentication to using BYODKIM.   Change from using Easy DKIM to using BYODKIM.   Change from using BYODKIM to using Easy DKIM.

    Args:
        email_identity(str): The email identity that you want to configure DKIM for.
        signing_attributes_origin(str): The method that you want to use to configure DKIM for the identity. There are two possible values:    AWS_SES – Configure DKIM for the identity by using Easy DKIM.    EXTERNAL – Configure DKIM for the identity by using Bring Your Own DKIM (BYODKIM).  .
        signing_attributes(Dict, optional): An object that contains information about the private key and selector that you want to use to configure DKIM for the identity. This object is only required if you want to configure Bring Your Own DKIM (BYODKIM) for the identity. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sesv2.email.identity.dkim.signing_attribute.put_multiple(
                ctx, email_identity=value, signing_attributes_origin=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sesv2.email.identity.dkim.signing_attribute.put_multiple email_identity=value, signing_attributes_origin=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sesv2",
        operation="put_email_identity_dkim_signing_attributes",
        op_kwargs={
            "EmailIdentity": email_identity,
            "SigningAttributesOrigin": signing_attributes_origin,
            "SigningAttributes": signing_attributes,
        },
    )
