"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def put_multiple(
    hub, ctx, email_identity: str, signing_enabled: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Used to enable or disable DKIM authentication for an email identity.

    Args:
        email_identity(str): The email identity that you want to change the DKIM settings for.
        signing_enabled(bool, optional): Sets the DKIM signing configuration for the identity. When you set this value true, then the messages that are sent from the identity are signed using DKIM. If you set this value to false, your messages are sent without DKIM signing. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sesv2.email.identity.dkim.attribute.put_multiple(
                ctx, email_identity=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sesv2.email.identity.dkim.attribute.put_multiple email_identity=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sesv2",
        operation="put_email_identity_dkim_attributes",
        op_kwargs={"EmailIdentity": email_identity, "SigningEnabled": signing_enabled},
    )
