"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def put_multiple(
    hub, ctx, email_identity: str, configuration_set_name: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Used to associate a configuration set with an email identity.

    Args:
        email_identity(str): The email address or domain that you want to associate with a configuration set.
        configuration_set_name(str, optional): The configuration set that you want to associate with an email identity. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sesv2.email.identity.configuration_set_attribute.put_multiple(
                ctx, email_identity=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sesv2.email.identity.configuration_set_attribute.put_multiple email_identity=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sesv2",
        operation="put_email_identity_configuration_set_attributes",
        op_kwargs={
            "EmailIdentity": email_identity,
            "ConfigurationSetName": configuration_set_name,
        },
    )
