"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, domain: str, start_date: str, end_date: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieve inbox placement and engagement rates for the domains that you use to send email.

    Args:
        domain(str): The domain that you want to obtain deliverability metrics for.
        start_date(str): The first day (in Unix time) that you want to obtain domain deliverability metrics for.
        end_date(str): The last day (in Unix time) that you want to obtain domain deliverability metrics for. The EndDate that you specify has to be less than or equal to 30 days after the StartDate.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sesv2.domain.statistic_report.get(
                ctx, domain=value, start_date=value, end_date=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sesv2.domain.statistic_report.get domain=value, start_date=value, end_date=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sesv2",
        operation="get_domain_statistics_report",
        op_kwargs={"Domain": domain, "StartDate": start_date, "EndDate": end_date},
    )
