"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    from_email_address: str,
    content: Dict,
    report_name: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Create a new predictive inbox placement test. Predictive inbox placement tests can help you predict how your messages will be handled by various email providers around the world. When you perform a predictive inbox placement test, you provide a sample message that contains the content that you plan to send to your customers. Amazon SES then sends that message to special email addresses spread across several major email providers. After about 24 hours, the test is complete, and you can use the GetDeliverabilityTestReport operation to view the results of the test.

    Args:
        report_name(str, optional): A unique name that helps you to identify the predictive inbox placement test when you retrieve the results. Defaults to None.
        from_email_address(str): The email address that the predictive inbox placement test email was sent from.
        content(Dict): The HTML body of the message that you sent when you performed the predictive inbox placement test.
        tags(List, optional): An array of objects that define the tags (keys and values) that you want to associate with the predictive inbox placement test. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sesv2.deliverability.test_report.create(
                ctx, from_email_address=value, content=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sesv2.deliverability.test_report.create from_email_address=value, content=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sesv2",
        operation="create_deliverability_test_report",
        op_kwargs={
            "ReportName": report_name,
            "FromEmailAddress": from_email_address,
            "Content": content,
            "Tags": tags,
        },
    )


async def get(hub, ctx, report_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieve the results of a predictive inbox placement test.

    Args:
        report_id(str): A unique string that identifies the predictive inbox placement test.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sesv2.deliverability.test_report.get(ctx, report_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sesv2.deliverability.test_report.get report_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sesv2",
        operation="get_deliverability_test_report",
        op_kwargs={"ReportId": report_id},
    )


async def list_all(hub, ctx, next_token: str = None, page_size: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Show a list of the predictive inbox placement tests that you've performed, regardless of their statuses. For predictive inbox placement tests that are complete, you can use the GetDeliverabilityTestReport operation to view the results.

    Args:
        next_token(str, optional): A token returned from a previous call to ListDeliverabilityTestReports to indicate the position in the list of predictive inbox placement tests. Defaults to None.
        page_size(int, optional): The number of results to show in a single call to ListDeliverabilityTestReports. If the number of results is larger than the number you specified in this parameter, then the response includes a NextToken element, which you can use to obtain additional results. The value you specify has to be at least 0, and can be no more than 1000. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sesv2.deliverability.test_report.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sesv2.deliverability.test_report.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sesv2",
        operation="list_deliverability_test_reports",
        op_kwargs={"NextToken": next_token, "PageSize": page_size},
    )
