"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def get_all(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Retrieve information about the status of the Deliverability dashboard for your account. When the Deliverability dashboard is enabled, you gain access to reputation, deliverability, and other metrics for the domains that you use to send email. You also gain the ability to perform predictive inbox placement tests. When you use the Deliverability dashboard, you pay a monthly subscription charge, in addition to any other fees that you accrue by using Amazon SES and other AWS services. For more information about the features and cost of a Deliverability dashboard subscription, see Amazon SES Pricing.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sesv2.deliverability.dashboard_option.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sesv2.deliverability.dashboard_option.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sesv2",
        operation="get_deliverability_dashboard_options",
        op_kwargs={},
    )


async def put(
    hub, ctx, dashboard_enabled: bool, subscribed_domains: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Enable or disable the Deliverability dashboard. When you enable the Deliverability dashboard, you gain access to reputation, deliverability, and other metrics for the domains that you use to send email. You also gain the ability to perform predictive inbox placement tests. When you use the Deliverability dashboard, you pay a monthly subscription charge, in addition to any other fees that you accrue by using Amazon SES and other AWS services. For more information about the features and cost of a Deliverability dashboard subscription, see Amazon SES Pricing.

    Args:
        dashboard_enabled(bool): Specifies whether to enable the Deliverability dashboard. To enable the dashboard, set this value to true.
        subscribed_domains(List, optional): An array of objects, one for each verified domain that you use to send email and enabled the Deliverability dashboard for. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sesv2.deliverability.dashboard_option.put(
                ctx, dashboard_enabled=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sesv2.deliverability.dashboard_option.put dashboard_enabled=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sesv2",
        operation="put_deliverability_dashboard_option",
        op_kwargs={
            "DashboardEnabled": dashboard_enabled,
            "SubscribedDomains": subscribed_domains,
        },
    )
