"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def put_multiple(hub, ctx, ip: str, warmup_percentage: int) -> Dict:
    r"""
    **Autogenerated function**

    Args:
        ip(str): The dedicated IP address that you want to update the warm-up attributes for.
        warmup_percentage(int): The warm-up percentage that you want to associate with the dedicated IP address.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sesv2.dedicated_ip.warmup_attribute.put_multiple(
                ctx, ip=value, warmup_percentage=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sesv2.dedicated_ip.warmup_attribute.put_multiple ip=value, warmup_percentage=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sesv2",
        operation="put_dedicated_ip_warmup_attributes",
        op_kwargs={"Ip": ip, "WarmupPercentage": warmup_percentage},
    )
