"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def put(hub, ctx, ip: str, destination_pool_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Move a dedicated IP address to an existing dedicated IP pool.  The dedicated IP address that you specify must already exist, and must be associated with your AWS account.  The dedicated IP pool you specify must already exist. You can create a new pool by using the CreateDedicatedIpPool operation.

    Args:
        ip(str): The IP address that you want to move to the dedicated IP pool. The value you specify has to be a dedicated IP address that's associated with your AWS account.
        destination_pool_name(str): The name of the IP pool that you want to add the dedicated IP address to. You have to specify an IP pool that already exists.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sesv2.dedicated_ip.in_pool.put(
                ctx, ip=value, destination_pool_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sesv2.dedicated_ip.in_pool.put ip=value, destination_pool_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sesv2",
        operation="put_dedicated_ip_in_pool",
        op_kwargs={"Ip": ip, "DestinationPoolName": destination_pool_name},
    )
